function logLike = calcLike(key,param)
% SYNTAX logLike = calcLike(key,param)

load(key.prefix)
icsfun = eval(['@',key.prefix,'_ics']);
stepfun = eval(['@',key.prefix,'_step_fit']);
measfun = eval(['@',key.prefix,'_meas_fit']);
[par,state,astate] = icsfun();
if nargin == 2
  par = param;
end
numNoise = [numel(key.noise.process),numel(key.noise.measurement)];

logLike = -EKFit(par,inp,meas,astate,...
                 eye(numel(astate)),1,numNoise,stepfun,measfun);
